;**************************************
;*
;* LEVEL FILE FORMAT:        SIZE OFFSET
;*    MAP DIMENSION NXN:       1     $00
;*    INIT PLAYER X POS:       1     $01
;*    INIT PLAYER Y POS:       1     $02
;*    INIT PLAYER ANGLE:       1     $03
;*    OBJECT DATABASE * 255:
;*        OBJECT TYPE:         1     $04
;*        OBJECT XPOS          1     $05
;*        OBJECT YPOS          1     $06
;*        OBJECT STATE         1     $07
;*    WALL MAP:  MAPSIZE*MAPSIZE   $1000
;*    TEXTURE PAGE MAP:    MS*MS   $1000+MS*MS
;*
;* IMAGE FILE FORMAT:        SIZE OFFSET
;*    IMAGE COUNT:              1    $00
;*    SPRITE OFFSET:            1    $01 
;*    TEXTURE PAGE OFFSET:     16    $02
;*    TEXUTRE PAGE CEIL CLR:   16    $12
;*    TEXUTRE PAGE FLOOR CLR:  16    $22
;*    TEXTURE MAP 1:          256  $0100
;*    TEXTURE MAP 2:          256  $0200
;*    TEXTURE MAP N:          256  $0N00
;*    SPRITE 1:               256 $N+100
;*    SPRITE M:               256 $N+M00
;*
;**************************************
;
; CONSTANTS
;
MAXOBJECTS	=	63
ACTORMVCNT	=	4
OBJTYPESPRTMSK	=	$7F
MINDIST	=	$40
MAXMOVE	=	$C0
FULLSCREENFPS	=	5	;FPS / 2
MIXSCREENFPS	=	6	;FPS / 2
WALLUPRORGINT	=	$05
WALLUPRORGFRAC	=	$FF
WALLLWRORGINT	=	$06
WALLLWRORGFRAC	=	$00
SPRTUPRORGINT	=	$05
SPRTUPRORGFRAC	=	$FF
SPRTLWRORGINT	=	$06
SPRTLWRORGFRAC	=	$00
DOORCLOSEWAIT	=	5
MINACTORMOVEDIST =	16
STRUGGLECNT	=	20
POWERUPCNT	=	15
STATEWAITING	=	0
STATELOOKING	=	0
STATEIDLE	=	0
STATECHASING	=	1
STATEDISABLED	=	3
GCBTTN1	=	$01
GCBTTN2	=	$02
GCLIMITDLY	=	15
;
; SOUND EFFECTS
;
SFXSILENCE	=	0
SFXDOOROPEN	=	1
SFXDOORCLOSE	=	2
SFXPOWERUP	=	3
SFXSTRUGGLE	=	4
;
; ZERO PAGE USAGE
;
TMPA	=	$00
TMPX	=	$01
TMPY	=	$02
REVA	=	$03
INCX	=	$04	;CURRENT INCREMENTAL X COORD
INCY	=	$04	;CURRENT INCREMENTAL Y COORD
INCMAJOR	=	$04	;INCREMENT FOR MAJOR AXIS
INCMINOR	=	$05	;INCREMENT FOR MINOR AXIS
DX	=	$06	;DELTA X FOR DDA
DY	=	$08	;DELTA Y FOR DDA
DLEN	=	$0A	;FRAC OF RAY LENGHT (HYPOTENUSE)
DERR	=	$0A	;CURRENT ERR TERRM
PREVX	=	$0C	;PREV X COORD
PREVY	=	$0E	;PREV Y COORD
WALLINDX	=	$08
SPRTINDX	=	$08
WALLSCALE	=	$0A
SPRTSCALE	=	$0A
RDCNT	=	$04
MOVEX	=	$06
MOVEY	=	$08
MOVELEN	=	$0A
MAPROW	=	$10	;POINTER TO PLAYER MAP ROW
OBJROW	=	$12	;POINTER TO PLAYER OBJECT ROW
TPGROW	=	$14	;POINTER TO PLAYER TEXTURE PAGE ROW
LVLPTR	=	$16	;WORKING LEVEL POINTER
MAPOFS	=	$16	;OFFSET INTO MAPS
MAPPTR	=	$18	;WORKING MAP POINTER
OBJPTR	= 	$1A	;WORKING OBJECT POINTER
SPRTPTR	=	$1C	;WORKING SPRITE POINTER
TEXPTR	=	$1E	;WORKING TEXTURE POINTER
TONE	=	$30	;CURRENT TONE VALUE
TONESAV	=	$31
SFXPTR	=	$32	;POINTER TO SFX
SFXPOS	=	$34	;POS IN SFX
ODBCUR	=	$42	;CURRENT OBJECT IN DATABASE
GCXPOS	=	$F0
GCYPOS	=	$F1
GCBTTNS	=	$F2
CNTRX	=	$F3
CNTRY	=	$F4
CLRTMP	=	$F5
CLRFLR	= 	$F6
CLRCEIL	= 	$F7
PROD	=	$FA
DVDND	=	$FA
DVSR	=	$FC
MAPWDTH	=	$FE	;MAP WIDTH IN BYTES
MAPSHFT	=	$FF	;MAP WIDTH IN SHIFTS
;
; GLOBAL PARAMETERS
;
LEVEL	=	$0300	;CURRENT MAPE LEVEL
RETCODE	=	$0301	;RETURN VALUE
LVLBASE	=	$0302	;BASE ADDRESS TO MAP LEVEL
IMGBASE	=	$0304	;BASE ADDRESS TO IMAGES
PLAYERX	=	$0306	;X COORD OF PLAYER
RAYX	=	$0306	;X COORD OF RAY
PLAYERY	=	$0308	;Y COORD OF PLAYER
RAYY	=	$0308	;Y COORD OF RAY
PLAYERA	=	$030A	;VIEW ANGLE OF PLAYER
SECONDS	=	$030B	;ELAPSED TIME
MINUTES	=	$030C
HOURS	=	$030D
ENERGY	=	$030E	;PLAYER ENERGY
RAYA	=	$0310	;ANGLE OF RAY
LVLMAPBASE	=	$0312
LVLTPGBASE	=	$0314
LVLOBJBASE	=	$0316
TEXBASE	=	$0318	;BASE ADDR OF CURRENT TEXTURE PAGE
SPRTBASE	=	$031A	;BASE ADDR OF SPRITES
VIEWCOLLEFT	=	$031D	;LEFT VIEW COLUMN
VIEWCOLRIGHT	=	$031E	;RIGHT VIEW COLUMN
JOYSTICK	=	$031F	;JOYSTICK ENABLE
AHEADOBJ	=	$0320	;OBJECT AHEAD OF PLAYER
AHEADPTR	=	$0324	;MAP PTR OF OBJECT
AHEADX	=	$0326	;OBJECT AHEAD X COORD
AHEADY	=	$0328	;OBJECT AHEAD Y COORD
AHEADDST	=	$032A	;OBJECT AHEAD DISTANCE
HITCNT	=	$032F	;COLLISON COUNT
HITOBJ	=	$0330	;COLLISION OBJECT
HITX	=	$0332	;COLLISION X COORD
HITY	=	$0334	;COLLISION Y COORD
HITDIST	=	$0336	;COLLISION DISTANCE
;
; HARDWARE ADDRESSES
;
KBHIT	=	$C000
KBSTROBE	=	$C010
SPEAKER	=	$C030
GCSTROBE	=	$C070
GC0	=	$C064
GC1	=	$C065
GCPB1	=	$C061
GCPB2	=	$C062
DISPGR	=	$C050
DISPTXT	=	$C051
DISPSPLIT	=	$C052
DISPFUL	=	$C052
DISPMIX	=	$C053
DISPPAGE	=	$C054
DISPPG1	=	$C054
DISPPG2	=	$C055
GRLORES	=	$C056
GRHIRES	=	$C057
